#############################################################################
# Tops - Gui Race Admin Module by Krayy
#############################################################################
# Ver 1.0.1 - 05 March 2010 Initial release
#############################################################################

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Info", "Tops", "1.00");
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH ( $command )
		CASE "!top":
			DoCifTops (ToUpper($argv), FALSE, FALSE);
			BREAK;
		CASE "!near":
			DoCifTops (ToUpper($argv), FALSE, TRUE);
			BREAK;
		CASE "!topqual":
			DoCifTops (ToUpper($argv), TRUE, FALSE);
			BREAK;
		CASE "!nearqual":
			DoCifTops (ToUpper($argv), TRUE, TRUE);
			BREAK;
	ENDSWITCH
EndCatchEvent

Sub DoCifTops ($DefTopCar, $flagQual, $flagNear)
	SetCurrentPlayerVar("flagQual", $flagQual);
	SetCurrentPlayerVar("flagNear", $flagNear);
	IF ( $DefTopCar == "" ) THEN
		# Get the players TopCar list
		$TopCarList = GetPlayerTopCars();
	ELSE
		$TopCarList = $DefTopCar;
	ENDIF
	SetCurrentPlayerVar("TopCars", $TopCarList);
   	DoCifInfoTops( 0, 0 );
EndSub

Sub DoCifInfoTops($KeyFlags,$id)
	$cifGroupName="Info";
	$cifModuleName="Tops";
	
	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Top Drivers");

	# Set various vars for GUI size and location
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";
	$topOrigT = $CifOrigT+1;			# Top edge of main content window
	$topOrigL = $CifOrigL+1;	# Left edge of main content window
	$topRowHeight = $CifRowHeight - 1;
	
	# Headings
	openPrivButton ($DialogPrefix . "toppos",$topOrigL,$topOrigT,10,$topRowHeight,1,-1,35, langEngine ("%{built_pos}%"));
	openPrivButton ($DialogPrefix . "topcar",$topOrigL+10,$topOrigT,10,$topRowHeight,1,-1,35, langEngine ("%{built_car}%"));
	openPrivButton ($DialogPrefix . "topnick",$topOrigL+20,$topOrigT,35,$topRowHeight,1,-1,99, langEngine ("%{built_nick}%"));
	openPrivButton ($DialogPrefix . "toppb",$topOrigL+55,$topOrigT,15,$topRowHeight,1,-1,35, langEngine ("%{built_pb}%"));
	openPrivButton ($DialogPrefix . "topsplits",$topOrigL+70,$topOrigT,28,$topRowHeight,1,-1,35, langEngine ("%{built_splits}%"));
	
	$currUName = getCurrentPlayerVar( "UserName" );
	$TopCarList = GetPlayerTopCars();

	# Check if the User has checked the buttons to display tops for Near or Qual
	$flagQual = GetCurrentPlayerVar("flagQual");
	IF ( $flagQual == "" ) THEN
		$flagQual = 0;
	ENDIF
	$flagNear = GetCurrentPlayerVar("flagNear");
	IF ( $flagNear == "" ) THEN
		$flagNear = 0;
	ENDIF

	# Lets write out the current World Record for this track
	$currWR = getWR();
	IF ( $currWR["racerName"] != "" )
	THEN
	$topOrigT = $topOrigT + $topRowHeight;	# Go down to the next printable row
	$bStyle = ISB_DARK;
	openPrivButton ($DialogPrefix . "wrpos",$topOrigL,$topOrigT,10,$topRowHeight,1,-1,$bStyle, "^6WR");
	openPrivButton ($DialogPrefix . "wrcar",$topOrigL+10,$topOrigT,10,$topRowHeight,1,-1,$bStyle, "^6" . $currWR["CName"]);
	openPrivButton ($DialogPrefix . "wrnick",$topOrigL+20,$topOrigT,35,$topRowHeight,1,-1,ISB_LEFT + $bStyle, "^6" . $currWR["racerName"] );
	openPrivButton ($DialogPrefix . "wrpb",$topOrigL+55,$topOrigT,15,$topRowHeight,1,-1,$bStyle, "^6" . NumToMSH( $currWR["WRTime"] ) );
	$wrsplits = "-";
	FOR( $k = 1; $k < 3; $k = $k +1 )
		$SplitTime = $currWR["Split".$k];
		IF ($SplitTime != 0) THEN
			IF ( $wrsplits == "-" ) THEN
				$wrsplits = NumToMSH($SplitTime);
			ELSE
				$wrsplits = $wrsplits . "/" . NumToMSH($SplitTime);
			ENDIF
		ENDIF
	ENDFOR
	openPrivButton ($DialogPrefix . "wrsplits",$topOrigL+70,$topOrigT,28,$topRowHeight,1,-1,$bStyle, "^6" . $wrsplits);
	ENDIF
	
    $list = GetListTop( $TopCarList, $flagQual, $flagNear );

	# GetListTop is hard coded for 24 results, so we go through the first 18 , because we have no more space
	FOR( $i = 0; $i < 18; $i = $i + 1)
		# Only show the line if it has a valid username
		IF ( $list[$i,"UserName"] != "") THEN
			IF( ToLower( $currUName ) == ToLower( $list[$i,"UserName"] ) ) THEN
				$bStyle = ISB_LIGHT;
			ELSE
				$bStyle = ISB_DARK;
			ENDIF
			$topOrigT = $topOrigT + $topRowHeight;	# Go down to the next printable row

			openPrivButton ($DialogPrefix . "toppos_" . $i,$topOrigL,$topOrigT,10,$topRowHeight,1,-1,$bStyle, "^7" . $list[$i,"Pos"]);
			openPrivButton ($DialogPrefix . "topcar_" . $i,$topOrigL+10,$topOrigT,10,$topRowHeight,1,-1,$bStyle, "^7" . $list[$i,"CName"]);
			openPrivButton ($DialogPrefix . "topnick_" . $i,$topOrigL+20,$topOrigT,35,$topRowHeight,1,-1,ISB_LEFT + $bStyle, "^7" . $list[$i,"NickName"]);
			IF ($list[$i,"PbLapTime"] > 3599000) THEN
				$colpb = ((3600000 - $list[$i,"PbLapTime"]) / 10) . "/" .  GetConfigVar( "LapTimeUsedForPb" ) + langEngine( "%{built_lapsdone}%" );
				$colpos = "-";
			ELSE
				$colpb = NumToMSH( $list[$i,"PbLapTime"] );
			ENDIF
			openPrivButton ($DialogPrefix . "toppb_" . $i,$topOrigL+55,$topOrigT,15,$topRowHeight,1,-1,$bStyle, "^7" . $colpb);
			$colsplit = "";
            FOR( $k = 0; $k < 3; $k = $k +1 )
				$SplitTime = $list[$i,"SplitTime".$k];
				IF ($SplitTime != 0) THEN
					IF ( $colsplit != "" ) THEN
						$colsplit = $colsplit . "/" . NumToMSH($SplitTime);
					ELSE
						$colsplit = NumToMSH($SplitTime);
					ENDIF
				ENDIF
			ENDFOR
			openPrivButton ($DialogPrefix . "topsplits_" . $i,$topOrigL+70,$topOrigT,28,$topRowHeight,1,-1,$bStyle, "^7" . $colsplit);

		ENDIF
	ENDFOR

	# Set a different button color if Near is set
	IF ( $flagNear == 1) THEN
		CifCmdButton( 2, "^3Near Times", TopToggleNearTimes );
	ELSE
		CifCmdButton( 2, "^7Near Times", TopToggleNearTimes );
	ENDIF

	# Set a different button color if Qual is set
	IF ( $flagQual == 1) THEN
		CifCmdButton( 3, "^3Qual Times", TopToggleQualTimes );
	ELSE
		CifCmdButton( 3, "^7Qual Times", TopToggleQualTimes );
	ENDIF

	# Now we're going to show the car buttons
	$topOrigT = (($CifOrigT + $CifHeight) - (($CifRowHeight * 3)-3));
	$topOrigL = $topOrigL - 1;
	openPrivButton ($DialogPrefix . "carbg",$topOrigL,$topOrigT,$CifWidth,$topRowHeight + 1,1,-1,ISB_DARK, "");
	
	$myCarList = SplitToArray($LFSCarList,",");
	$i = 0;
	$num = arrayCount( $myCarList );
	WHILE ($i < $num)
		IF ( $myCarList[$i] != "" ) THEN
			$idxOfThisCar = indexOf( $TopCarList, $myCarList[$i]);
			IF ( $idxOfThisCar != -1 ) THEN
				openPrivButton ($DialogPrefix . $myCarList[$i],$topOrigL,$topOrigT,5,$topRowHeight,1,-1,ISB_NONE, "^3" . $myCarList[$i], TopToggleCar);
			ELSE
				openPrivButton ($DialogPrefix . $myCarList[$i],$topOrigL,$topOrigT,5,$topRowHeight,1,-1,ISB_NONE, "^7" . $myCarList[$i], TopToggleCar);
			ENDIF
			$topOrigL = $topOrigL + 5;
		ENDIF
		$i = $i + 1;
	ENDWHILE
EndSub

# Toggle flagNear between 0 and 1
Sub TopToggleNearTimes ( $KeyFlags, $id )
	$flagNear = GetCurrentPlayerVar("flagNear");
	IF ( $flagNear == "" | $flagNear == 0) THEN
		SetCurrentPlayerVar("flagNear", "1");
	ELSE
		SetCurrentPlayerVar("flagNear", "0");
	ENDIF
   	DoCifInfoTops( 0, GetCurrentPlayerVar("TopCars") );
EndSub

# Toggle flagQual between 0 and 1
Sub TopToggleQualTimes ( $KeyFlags, $id )
	$flagQual = GetCurrentPlayerVar("flagQual");
	IF ( $flagQual == "" | $flagQual == 0) THEN
		SetCurrentPlayerVar("flagQual", "1");
	ELSE
		SetCurrentPlayerVar("flagQual", "0");
	ENDIF
   	DoCifInfoTops( 0, GetCurrentPlayerVar("TopCars") );
EndSub

# Toggle flagNear between 0 and 1
Sub TopToggleCar ( $KeyFlags, $id )
	$TopCars = GetPlayerTopCars();

	$CName = split( $id,"_",1 );
	$idxOfCName = indexOf( $TopCars, $CName);
	IF ( $idxOfCName == -1 ) THEN
		$TopCars = $CName . "+" . $TopCars;
	ELSE
		$TopCars = StrReplace($TopCars,$CName . "+","");
		$TopCars = StrReplace($TopCars,"+" . $CName,"");
	ENDIF
	SetCurrentPlayerVar("TopCars", $TopCars);
   	DoCifInfoTops( 0, GetCurrentPlayerVar("TopCars") );
EndSub

Sub GetPlayerTopCars()
	# Use the DeafultTopCar if a player doesn't have it already set
	$TopCars = GetCurrentPlayerVar("TopCars");
	IF ( $TopCars == "" ) THEN
		$TopCars = getConfigVar("DefaultTopCar");
		
		# Add Players current car into TopCar list as well
		$CName = GetCurrentPlayerVar("Car");
		$idxOfCName = indexOf( $TopCars, $CName);
		IF ( $idxOfCName == -1 ) THEN
			$TopCars = $CName . "+" . $TopCars;
		ENDIF
		SetCurrentPlayerVar("TopCars", $TopCars);
	ENDIF
	return ($TopCars);
EndSub
